<?php

namespace App\Services\WaterDepartment;

use App\Mail\SendMail;
use App\Models\Status;
use App\Services\CommonService;
use App\Services\CurlAPiService;
use App\Models\ServiceCredential;
use App\Models\WaterPrabhagWards;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use App\Services\AapaleSarkarLoginCheckService;
use App\Models\WaterDepartment\Illegalwaterconnection;

class IllegalWaterConnectionService
{
    protected $curlAPiService;
    protected $aapaleSarkarLoginCheckService;
    protected $commonservice;

    public function __construct(CurlAPiService $curlAPiService, AapaleSarkarLoginCheckService $aapaleSarkarLoginCheckService, CommonService $commonService)
    {
        $this->curlAPiService = $curlAPiService;
        $this->aapaleSarkarLoginCheckService = $aapaleSarkarLoginCheckService;
        $this->commonService = $commonService;
    }

    public function store($request)
    {
        DB::beginTransaction();

        try {
            $user = Auth::user();
            $request['user_id'] = Auth::user()->id;
            $request['service_id'] = "22";
            $request['ward_area'] = WaterPrabhagWards::where('ward_name', $request->zone)->value('id'); // returns a single value instead of a collection

            if ($request->hasFile('application_documents')) {
                $request['application_document'] = $request->application_documents->store('water-department/illegal-water-connection','public');
            }

              if ($request->hasFile('comments')) {
                $request['comment'] = $request->comments->store('water-department/illegal-water-connection','public');
            }

            
            $illegalwaterconnection = Illegalwaterconnection::create($request->except('application_no'));


            if ($illegalwaterconnection) {
                $applicationNo = 'MBMC/' . $request['service_id'] . '/' . $illegalwaterconnection->id . '/' . date('dmY');
                $illegalwaterconnection->application_no = $applicationNo;
                $illegalwaterconnection->save();

            $status = Status::create([
                    'user_id' => $request['user_id'],
                    'service_id' =>22,
                    'department_id' =>5,
                    'table_id' => $illegalwaterconnection->id,
                ]);

            $this->commonService->store_approval_hierarchies($illegalwaterconnection, $user, $status);
            }

            // code to send data to department
            // if ($request->hasFile('application_documents')) {
            //     $request['application_document'] = $this->curlAPiService->convertFileInBase64($request->file('application_documents'));
            // } else {
            //     $request['application_document'] = "";
            // }
            // $request['user_id'] = (Auth::user()->user_id && Auth::user()->user_id != "") ? Auth::user()->user_id : Auth::user()->id;
            // $newData = $request->except(['_token', 'application_documents']);
            // $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.water') . 'WaterBillMicroService/WaterbillApi/ApleSarkarService/RequestForComplaintOfIIlegalWaterConnection', '');

            // Decode JSON string to PHP array
            // $data = json_decode($data, true);
            // if (isset($data['status']) && $data['status'] == "200") {
            //     // Access the application_no
            //     $applicationId = $data['applicationId'];
            //     Illegalwaterconnection::where('id', $illegalwaterconnection->id)->update([
            //         'application_no' => $applicationId
            //     ]);

            //     if (Auth::user()->is_aapale_sarkar_user) {
            //         $aapaleSarkarCredential = ServiceCredential::where('dept_service_id', $request->service_id)->first();
            //         $serviceDay = ($aapaleSarkarCredential->service_day) ? $aapaleSarkarCredential->service_day : 20;

            //         $send = $this->aapaleSarkarLoginCheckService->encryptAndSendRequestToAapaleSarkar(Auth::user()->trackid, $aapaleSarkarCredential->client_code, Auth::user()->user_id, $aapaleSarkarCredential->service_id, $applicationId, 'N', 'NA', 'N', 'NA', $serviceDay, date('Y-m-d', strtotime("+$serviceDay days")), config('rtsapiurl.amount'), config('rtsapiurl.requestFlag'), config('rtsapiurl.applicationStatus'), config('rtsapiurl.applicationPendingStatusTxt'), $aapaleSarkarCredential->ulb_id, $aapaleSarkarCredential->ulb_district, 'NA', 'NA', 'NA', $aapaleSarkarCredential->check_sum_key, $aapaleSarkarCredential->str_key, $aapaleSarkarCredential->str_iv, $aapaleSarkarCredential->soap_end_point_url, $aapaleSarkarCredential->soap_action_app_status_url);

            //         if (!$send) {
            //             $this->aapaleSarkarLoginCheckService->savePendingAapaleSarkarData($applicationId, $request->service_id, Auth::user()->user_id);
            //             DB::commit();
            //             return [true];
            //         }
            //     }
            //     // $subject = "Testing Subject";
            //     // $message = "Testing Message";
            //     // Mail::to($request->email_id)->send(new SendMail($subject, $message));
            // } else {
            //     DB::rollback();
            //     return [false, $data['error']];
            // }
            // end of code to send data to department

            DB::commit();
            return [true];
        } catch (\Exception $e) {
            DB::rollback();
            Log::error('Error in store method: ' . $e->getMessage());
            return [false, $e->getMessage()];
        }
    }


    public function edit($id)
    {
        return Illegalwaterconnection::find($id);
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {
            $user = Auth::user();
            // Find the existing record
            $illegalwaterconnection = Illegalwaterconnection::findOrFail($id);

            // Handle file uploads and update original file names
            if ($request->hasFile('application_documents')) {
                if ($illegalwaterconnection && Storage::exists($illegalwaterconnection->application_document)) {
                    Storage::delete($illegalwaterconnection->application_document);
                }
                $request['application_document'] = $request->application_documents->store('water-department/illegal-water-connection');
            }


             if ($request->hasFile('comments')) {
                if ($illegalwaterconnection && Storage::exists($illegalwaterconnection->comment)) {
                    Storage::delete($illegalwaterconnection->comment);
                }
                $request['comment'] = $request->comments->store('water-department/illegal-water-connection');
            }
            // Update the rest of the fields
            $illegalwaterconnection->update($request->all());

            DB::commit();
            return [true];

            // code to send data to department
            // if ($request->hasFile('application_documents')) {
            //     $request['application_document'] = $this->curlAPiService->convertFileInBase64($request->file('application_documents'));
            // } else {
            //     $request['application_document'] = "";
            // }
            // $request['application_no'] = $illegalwaterconnection->application_no;
            // $request['user_id'] = (Auth::user()->user_id && Auth::user()->user_id != "") ? Auth::user()->user_id : Auth::user()->id;
            // $newData = $request->except(['_token', 'id', 'application_documents']);
            // $data = $this->curlAPiService->sendPostRequestInObject($newData, config('rtsapiurl.water') . 'WaterBillMicroService/WaterbillApi/ApleSarkarService/RequestForUpdateComplaintOfIIlegalWaterConnection', '');

            // // Decode JSON string to PHP array
            // $data = json_decode($data, true);

            // if (isset($data['status']) && $data['status'] == "200") {
            //     // Access the application_no
            //     DB::commit();
            //     return [true];
            // } else {
            //     DB::rollback();
            //     return [false, $data['error']];
            // }
            // end of code to send data to department
        } catch (\Exception $e) {
            DB::rollback();
            Log::info($e);
            return [false, $e->getMessage()];
        }
    }
}
