<?php

namespace App\Traits;

use App\Models\ApprovalHierarchies;

trait HasApprovalFlow
{
    public function approvals()
    {
        return $this->hasMany(ApprovalHierarchies::class, 'table_id')
                    ->where('service_id', $this->service_id ?? class_basename($this));
    }

    public function currentStatus()
    {
        return $this->approvals()->latest()->first()?->status;
    }
}
