<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Service Model to Table Mappings
    |--------------------------------------------------------------------------
    |
    | This file maps service models to their corresponding database tables and
    | specifies which column should be used to find the application row.
    |
    | Format:
    | 'table_name' => [
    |     'application_column' => 'column_name_for_application_id',
    |     'model' => 'Full\Class\Name\Of\Model',
    |     'service_name' => 'Human readable service name'
    | ]
    */

    'water_new_connection' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\WaterNewConnection',
        'service_name' => 'Water New Connection'
    ],

    'water_illegal_connection' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\WaterIllegalConnection',
        'service_name' => 'Water Illegal Connection'
    ],

    'water_change_ownership' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\WaterChangeOwnership',
        'service_name' => 'Water Change Ownership'
    ],

    'water_connection_size_change' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\WaterConnectionSizeChange',
        'service_name' => 'Water Connection Size Change'
    ],

    'water_reconnection' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\WaterReconnection',
        'service_name' => 'Water Reconnection'
    ],

    'water_disconnect_supply' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\WaterDisconnectSupply',
        'service_name' => 'Water Disconnect Supply'
    ],

    'trade_new_license' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\TradeNewLicense',
        'service_name' => 'Trade New License'
    ],

    'trade_renewal_license' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\TradeRenewalLicense',
        'service_name' => 'Trade Renewal License'
    ],

    'trade_plumber_license' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\TradePlumberLicense',
        'service_name' => 'Trade Plumber License'
    ],

    'marriage_registration' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\MarriageRegistration',
        'service_name' => 'Marriage Registration'
    ],

    'fire_noc' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\FireNoc',
        'service_name' => 'Fire NOC'
    ],

    'construction_drainage_connection' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\DrainageConnection',
        'service_name' => 'Construction Drainage Connection'
    ],

    'construction_road_cutting' => [
        'application_column' => 'application_no',
        'model' => 'App\Models\RoadCuttingPermission',
        'service_name' => 'Construction Road Cutting'
    ],

    // Add more service mappings here as needed
];