<?php

return [

    /*
    |--------------------------------------------------------------------------
    | SMS API Configuration
    |--------------------------------------------------------------------------
    */

    'api_url' => env('SMS_API_URL', 'https://japi.instaalerts.zone/httpapi/QueryStringReceiver'),

    'api_key' => env('SMS_API_KEY', 'kL0z7nP8UuFdJtb505GzOQ=='),

    'dlt_entity_id' => env('SMS_DLT_ENTITY_ID', '1001158085062848906'),

    /*
    |--------------------------------------------------------------------------
    | Sender IDs
    |--------------------------------------------------------------------------
    | pt → general / approval messages
    | rt → rejection messages
    | wt → payment link messages
    */

    'senders' => [
        'pt' => env('SMS_SENDER_PT', 'MBMCPT'),
        'rt' => env('SMS_SENDER_RT', 'MBMCRT'),
        'wt' => env('SMS_SENDER_WT', 'MBMCWT'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Template IDs
    |--------------------------------------------------------------------------
    | Map your registered DLT templates here
    */

    'templates' => [
        // Received under RTS
        'received'         => env('SMS_TEMPLATE_RECEIVED_ID', '1007188868564245227'),

        // Approved at current level
        'approved_level'   => env('SMS_TEMPLATE_APPROVED_LEVEL_ID', '1007034288931686927'),

        // Rejected
        'rejected'         => env('SMS_TEMPLATE_REJECTED_ID', '1007104082231973877'),

        // Final approval
        'approved_final'   => env('SMS_TEMPLATE_APPROVED_FINAL_ID', '1007609924104701451'),

        // Payment link (custom)
        'payment_link'     => env('SMS_TEMPLATE_PAYMENT_LINK_ID', ''),
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Payment Link
    |--------------------------------------------------------------------------
    */

    'payment_link' => env('PAYMENT_LINK', 'https://mbmc.gov.in'),
];
