<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // public function up(): void
    // {
    //     Schema::create('payment_statuses', function (Blueprint $table) {
    //         $table->id();
    //         $table->foreignId('service_id')->constrained('services')->onDelete('cascade');
    //         $table->unsignedBigInteger('table_id');
    //         $table->decimal('amount', 10, 2);
    //         $table->tinyInteger('status')->default(0); // 0=pending, 1=paid, 2=failed
    //         $table->string('transaction_id')->nullable();
    //         $table->dateTime('payment_date')->nullable();
    //         $table->string('payment_mode')->nullable();
    //         $table->timestamps();
    //     });
    // }

    public function up(): void
{
    if (!Schema::hasTable('payment_statuses')) {
        Schema::create('payment_statuses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('service_id')->constrained('services')->onDelete('cascade');
            $table->unsignedBigInteger('table_id');
            $table->decimal('amount', 10, 2);
            $table->tinyInteger('status')->default(0); 
            $table->string('transaction_id')->nullable();
            $table->dateTime('payment_date')->nullable();
            $table->string('payment_mode')->nullable();
            $table->timestamps();
        });
    }
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_statuses');
    }
};