<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('demolishing_properties', function (Blueprint $table) {
            $table->string('property_owner_name')->nullable();
            $table->text('property_address')->nullable();
            $table->unsignedBigInteger('ward')->nullable(); // foreign key if needed
            $table->string('survey_number')->nullable();
            $table->string('property_number')->nullable();
            $table->decimal('property_area', 10, 2)->nullable();
            $table->string('property_usage')->nullable();
            $table->string('construction_type')->nullable();
            $table->enum('is_authorized_construction', ['yes', 'no'])->nullable();
            $table->enum('has_water_connection', ['yes', 'no'])->nullable();
            $table->string('application_file')->nullable();
            $table->string('no_dues_certificate')->nullable();
            });
        }

    /**
     * Reverse the migrations.
     */
   public function down()
{
    Schema::table('demolishing_properties', function (Blueprint $table) {
        $table->dropColumn([
            'property_owner_name',
            'property_address',
            'ward',
            'survey_number',
            'property_number',
            'property_area',
            'property_usage',
            'construction_type',
            'is_authorized_construction',
            'has_water_connection',
            'application_file',
            'no_dues_certificate',
        ]);
    });
}

};
