<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('property_division_into_sub_divisions', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('service_id')->nullable();
            $table->string('application_no')->nullable();
            $table->string('speech_no')->nullable();
            $table->string('date')->nullable();
            $table->string('subject')->nullable();
            $table->string('property_name')->nullable();
            $table->string('property_address')->nullable();
            $table->string('property_infom')->nullable();
            $table->string('doc_upload')->nullable();
            $table->string('ip')->nullable();
            $table->string('ward_area')->nullable();
            $table->string('email')->nullable();
            $table->string('mobile_no')->nullable();
            $table->tinyInteger('status')->default(0)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('property_division_into_sub_divisions');
    }
};
