<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('private_infrastructure_work_permissions', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('ip')->nullable();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email_id')->nullable();
            $table->string('property_owner_name')->nullable();
            $table->string('property_address')->nullable();
            $table->string('ward')->nullable();
            $table->string('property_type')->nullable();
            $table->string('authorization')->nullable();
            $table->string('plan_copy')->nullable();
            $table->string('side_visit_geotag_pic')->nullable();
            $table->string('property_doc')->nullable();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->string('is_payment_paid_aapale_sarkar')->nullable();
            $table->string('aapale_sarkar_payment_date')->nullable();
            $table->string('status')->default('0');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('private_infrastructure_work_permissions');
    }
};
