<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vikas_kamach_gopniy_dakhlas', function (Blueprint $table) {
            $table->string('service_id')->nullable();
            $table->string('application_no')->nullable();
            $table->string('status')->default('0');
            $table->string('ip')->nullable();
            $table->bigInteger('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vikas_kamach_gopniy_dakhlas', function (Blueprint $table) {
            $table->dropColumn(['service_id', 'application_no', 'status', 'ip', 'user_id']);
        });
    }
};
