<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vibhagakade_thakbaki_naslyache_pramanpatras', function (Blueprint $table) {
            $table->id();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email_id')->nullable();
            $table->string('service_id')->nullable();
            $table->string('application_no')->nullable();
            $table->string('status')->default('0');
            $table->string('ip')->nullable();
            $table->bigInteger('user_id');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vibhagakade_thakbaki_aslyache_pramanpatras', function (Blueprint $table) {
            $table->dropColumn(['applicant_name', 'applicant_address', 'mobile_no', 'email_id', 'service_id', 'application_no', 'status', 'ip', 'user_id']);
        });
    }
};
