<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('development_works_quantities', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('ip')->nullable();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email_id')->nullable();
            $table->string('company_name')->nullable();
            $table->string('work_name')->nullable();
            $table->string('work_order_no')->nullable();
            $table->string('work_completition_date')->nullable();
            $table->string('work_order_doc')->nullable();
            $table->string('work_completition_doc')->nullable();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->string('is_payment_paid_aapale_sarkar')->nullable();
            $table->string('aapale_sarkar_payment_date')->nullable();
            $table->string('status')->default('0');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('development_works_quantities');
    }
};
