<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('property_division_into_sub_divisions', function (Blueprint $table) {
            $table->string('upload_prescribed_formats')->nullable()->after('doc_upload');
            $table->string('upload_no_due_doc')->nullable()->after('upload_prescribed_formats');
            $table->string('owner_doc')->nullable()->after('upload_no_due_doc');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('property_division_into_sub_divisions', function (Blueprint $table) {
            $table->dropColumn(['upload_prescribed_formats', 'upload_no_due_doc', 'owner_doc']);
        });
    }
};
