<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('building_permissions', function (Blueprint $table) {
            $table->string('upload_prescribed_formats')->nullable();
            $table->string('upload_homecertificate')->nullable();
            $table->string('property_doc')->nullable();
            $table->string('building_doc')->nullable();
            $table->string('count_map_doc')->nullable();
            $table->string('worker_doc')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('building_permissions', function (Blueprint $table) {
            $table->dropColumn('upload_prescribed_formats');
            $table->dropColumn('upload_homecertificate');
            $table->dropColumn('property_doc');
            $table->dropColumn('building_doc');
            $table->dropColumn('count_map_doc');
            $table->dropColumn('worker_doc');
        });
    }
};
