<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_change_ownerships', function (Blueprint $table) {
            $table->string('connection_no')->nullable()->after('zone');
            $table->string('owner_name')->nullable()->after('connection_no');
            $table->string('owner_add')->nullable()->after('owner_name');
            $table->string('total_connection')->nullable()->after('owner_add');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_change_ownerships', function (Blueprint $table) {
            $table->string('connection_no')->nullable()->after('zone');
            $table->string('owner_name')->nullable()->after('connection_no');
            $table->string('owner_add')->nullable()->after('owner_name');
            $table->string('total_connection')->nullable()->after('owner_add');
        });
    }
};
