<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_tax_bills', function (Blueprint $table) {
            $table->string('owner_full_add')->nullable()->after('zone');
            $table->string('water_connection')->nullable()->after('owner_full_add');
            $table->string('water_sub_usage')->nullable()->after('water_connection');
            $table->string('connection_size')->nullable()->after('water_sub_usage');
            $table->string('billing_cycle')->nullable()->after('connection_size');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_tax_bills', function (Blueprint $table) {
            $table->string('owner_full_add')->nullable()->after('zone');
            $table->string('water_connection')->nullable()->after('owner_full_add');
            $table->string('water_sub_usage')->nullable()->after('water_connection');
            $table->string('connection_size')->nullable()->after('water_sub_usage');
            $table->string('billing_cycle')->nullable()->after('connection_size');
        });
    }
};
