<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('insurance_births', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();
            $table->string('ip')->nullable();
            $table->string('application_no')->nullable();
            $table->string('surname')->nullable();
            $table->string('name')->nullable();
            $table->string('father_name')->nullable();
            $table->string('address')->nullable();
            $table->string('room_name')->nullable();
            $table->string('block_no')->nullable();
            $table->string('road_name')->nullable();
            $table->string('ward')->nullable();
            $table->string('pincode_no')->nullable();
            $table->string('ward_no')->nullable();
            $table->string('mbmc_elec_ward_no')->nullable();
            $table->string('contact_no')->nullable();
            $table->string('mother_full_name')->nullable();
            $table->string('father_full_name')->nullable();
            $table->string('mother_father_address')->nullable();
            $table->string('birth_place')->nullable();
            $table->string('birth_date')->nullable();
            $table->string('gender')->nullable();
            $table->string('child_name')->nullable();
            $table->string('no_of_certificate')->nullable();
            // $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->string('is_payment_paid_aapale_sarkar')->nullable();
            $table->string('aapale_sarkar_payment_date')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('insurance_births');
    }
};
