<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('failure_water_supply', function (Blueprint $table) {
            $table->id();
            $table->string('applicantname')->nullable();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('email')->nullable();
            $table->string('mobileno')->nullable();
            $table->string('zone')->nullable();
            $table->string('waterconnectionno')->nullable();
            $table->string('propertyno')->nullable();
            $table->string('adhaarno')->nullable();
            $table->string('application_doc')->nullable();
            $table->string('bill_doc')->nullable();
            $table->string('status')->default('0');
            $table->string('ip')->nullable();
            $table->bigInteger('user_id');
             $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('failure_water_supply');
    }
};
