<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sewerage_properties', function (Blueprint $table) {
            $table->id();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('zone')->nullable();
            $table->string('property_no')->nullable();
            $table->string('application_doc')->nullable();
            $table->string('bill_doc')->nullable();
            $table->string('status')->nullable();
            $table->string('tax_no')->nullable();
            $table->string('user_id')->nullable();
            $table->string('ip')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sewerage_properties');
    }
};
