<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('water_dues', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();
            $table->string('ip')->nullable();
            $table->string('applicant_full_name')->nullable();
            $table->string('application_no')->nullable();
            $table->string('applicant_full_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email_id')->nullable();
            $table->string('adhar_no')->nullable();
            $table->string('total_connection')->nullable();
            $table->string('connection_no')->nullable();
            $table->string('owner_name')->nullable();
            $table->string('owner_full_add')->nullable();
            $table->string('landmark')->nullable();
            $table->string('ward')->nullable();
            $table->string('zone')->nullable();
            $table->string('connection_size')->nullable();
            $table->string('upload_water_bill')->nullable();
            $table->string('service_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->string('is_payment_paid_appale_sarkar')->nullable();
            $table->string('appale_sarkar_payment_date')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('water_dues');
    }
};
