<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('civil_local_self_government_nominations', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->nullable();
            $table->string('ip')->nullable();
            $table->string('zone')->nullable();
            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('marathi_first_name')->nullable();
            $table->string('marathi_middle_name')->nullable();
            $table->string('marathi_last_name')->nullable();
            $table->string('mobile_num')->nullable();
            $table->string('adhar_num')->nullable();
            $table->string('email')->nullable();
            $table->string('address')->nullable();
            $table->string('marathi_address')->nullable();
            $table->string('purpose')->nullable();
            $table->string('marathi_purpose')->nullable();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->string('is_paymnet_paid_appale_sarkar')->nullable();
            $table->string('appale_sarkar_payment_date')->nullable();
            $table->string('status')->default('0')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('civil_local_self_government_nominations');
    }
};
