<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('solarpower', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id');
            $table->string('ip')->nullable();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('stall_type')->nullable();
            $table->string('stall_place')->nullable();
            $table->string('authorization')->nullable();
            $table->string('mul_parnaga_pic')->nullable();
            $table->string('adhar_card_pic')->nullable();
            $table->string('pic')->nullable();
            $table->string('handicap_pic')->nullable();
            $table->string('caste_pic')->nullable();
            $table->string('milk_center_pic')->nullable();
            $table->string('gumasta_license_pic')->nullable();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->string('is_payment_paid_aapale_sarkar')->nullable();
            $table->string('aapale_sarkar_payment_date')->nullable();
            $table->string('status')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('solarpower');
    }
};
