<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('guttercover', function (Blueprint $table) {
            $table->id();
            $table->string('application_name')->nullable();
            $table->string('area')->nullable();
            $table->string('location')->nullable();
            $table->string('landmark')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email')->nullable();
            $table->string('adhaarno')->nullable();
            $table->string('ward')->nullable();
            $table->string('details')->nullable();
            $table->string('pincode')->nullable();
            $table->string('gpsphoto')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('service_id')->nullable();
            $table->string('ip')->nullable();
            $table->date('aapale_sarkar_payment_date')->nullable();
            $table->string('status')->default('0')->nullable();
            $table->string('application_no')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('guttercover');
    }
};
