<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Department;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('approval_request_hierarchies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('requester_department_id')->nullable()->constrained('departments');
            $table->unsignedBigInteger('first_approver_designation_id')->nullable();
            $table->unsignedBigInteger('second_approver_designation_id')->nullable();
            $table->unsignedBigInteger('third_approver_designation_id')->nullable();
            $table->unsignedBigInteger('fourth_approver_designation_id')->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('approval_request_hierarchies');
    }
};
