<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('approval_hierarchies', function (Blueprint $table) {
            $table->id();
            $table->string('service_id')->nullable();
            $table->integer('status_id')->nullable();
            $table->integer('table_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('approver_user_id')->nullable();
            $table->integer('status')->default(0)->comment('0=pending, 1=approve, 2=reject');
            $table->integer('next_approval_flag')->nullable();
            $table->string('remark')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('approval_hierarchies');
    }
};
