<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
     public function up()
    {
        Schema::create('construction_road_cutting_road_details', function (Blueprint $table) {
            $table->id();
            $table->integer('construction_road_cutting_id')->nullable();
            $table->integer('roadtype')->nullable();
            $table->integer('defect_factor')->nullable();
            $table->string('startpoint')->nullable();
            $table->string('endpoint')->nullable();
            $table->decimal('length', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('construction_road_cutting_road_details');
    }
};
