<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('gratingtelecomdetails', function (Blueprint $table) {
            $table->id();
            $table->integer('gratingtelecom_id')->nullable();
            $table->integer('roadtype')->nullable();
            $table->integer('defect_factor')->nullable();
            $table->string('startpoint')->nullable();
            $table->string('endpoint')->nullable();
            $table->decimal('length', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('gratingtelecomdetails');
    }
};
