<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transaction', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('service_id')->nullable();
            $table->integer('table_id')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('amount');
            $table->string('orderno')->nullable();
            $table->unsignedTinyInteger('status')->default(0)->comment("0 = pending, 1 = success, 2 = failed, 3 = waiting/cancelled");
            $table->text('details')->nullable();
            $table->string('ip')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transaction');
    }
};
