<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('city_clean', function (Blueprint $table) {
            $table->id();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('user_id')->nullable();
            $table->string('ip')->nullable();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email')->nullable();
            $table->string('aadhar_num')->nullable();
            $table->string('address')->nullable();
            $table->string('geo_photos')->nullable();
            $table->string('upload_prescribed_docs')->nullable();
            $table->string('status')->default('0')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->date('payment_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('city_clean');
    }
};
