<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('windblow', function (Blueprint $table) {
            $table->id();
            $table->string('application_no')->nullable();
            $table->string('service_id')->nullable();
            $table->string('user_id')->nullable();
            $table->string('applicant_name')->nullable();
            $table->string('applicant_address')->nullable();
            $table->string('mobile_no')->nullable();
            $table->string('email_id')->nullable();
            $table->string('owner_name')->nullable();
            $table->string('owner_address')->nullable();
            $table->string('prabhag_samiti')->nullable();
            $table->string('cc_oc_certificates')->nullable();
            $table->string('fire_nocs')->nullable();
            $table->string('solid_waste_nocs')->nullable();
            $table->string('structural_stability_certificates')->nullable();
            $table->string('electrical_safety_certificates')->nullable();
            $table->string('water_supply_sewage_nocs')->nullable();
            $table->string('prabhag_office_nocs')->nullable();
            $table->string('school_gps_photos')->nullable();
            $table->string('upload_prescribeds')->nullable();
            $table->string('is_payment_paid')->nullable();
            $table->date('payment_date')->nullable();
            $table->string('status')->default(0)->nullable();
            $table->string('ip')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('windblow');
    }
};
