<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('marriage_new_reg_details', function (Blueprint $table) {
 $table->id();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users');
            $table->string('mp_id',100)->nullable();
            $table->string('service_id',100)->nullable();
            $table->string('ip',100)->nullable();
            $table->string('application_no',100)->nullable();
            $table->string('service_name',100)->nullable();
            $table->string('registration_from_applicant_mobile_no',100)->nullable();
            $table->string('registration_from_applicant_full_name',100)->nullable();
            $table->text('registration_from_applicant_home_address')->nullable();
            $table->string('registration_from_pincode',100)->nullable();
            $table->string('registration_from_applicant_email',100)->nullable();
            $table->string('registration_from_aadhar_card_no',100)->nullable();
            $table->string('registration_from_alternate_mobile_number',100)->nullable();
            $table->string('registration_from_pan_card_no',100)->nullable();
            $table->string('registration_from_residential_ward_name',100)->nullable();
            $table->string('registration_from_marriage_solemnized_within_maharashtra_state',100)->nullable();

            $table->date('registration_details_form_filled_date')->nullable();
            $table->date('registration_details_marriage_date_in_english')->nullable();
            $table->string('registration_details_marriage_date_in_marathi',100)->nullable();
            $table->text('registration_details_marriage_place_in_english')->nullable();
            $table->text('registration_details_marriage_place_in_marathi')->nullable();
            $table->string('registration_details_couple_photo',100)->nullable();
            $table->string('registration_details_is_widow',100)->nullable();
            $table->string('registration_details_is_previously_divorced',100)->nullable();
            $table->string('registration_details_is_marriage_intercaste',100)->nullable();
            $table->string('registration_details_wedding_card_image',100)->nullable();

            $table->string('groom_info_fname_in_english',100)->nullable();
            $table->string('groom_info_mname_in_english',100)->nullable();
            $table->string('groom_info_lname_in_english',100)->nullable();
            $table->string('groom_info_fname_in_marathi',100)->nullable();
            $table->string('groom_info_mname_in_marathi',100)->nullable();
            $table->string('groom_info_lname_in_marathi',100)->nullable();
            $table->text('groom_info_address_in_english')->nullable();
            $table->text('groom_info_address_in_marathi')->nullable();
            $table->string('groom_info_pincode',100)->nullable();
            $table->string('groom_info_pincode_in_marathi',100)->nullable();
            $table->string('groom_info_mobile_no',100)->nullable();
            $table->string('groom_info_email',100)->nullable();
            $table->string('groom_info_aadhar_card_no',100)->nullable();
            $table->date('groom_info_dob',)->nullable();
            $table->string('groom_info_age',100)->nullable();
            $table->string('groom_info_gender',100)->nullable();
            $table->string('groom_info_religion_by_birth',100)->nullable();
            $table->string('groom_info_religion_by_adoption',100)->nullable();
            $table->string('groom_info_photo',100)->nullable();
            $table->string('groom_info_id_proof',100)->nullable();
            $table->string('groom_info_residential_proof',100)->nullable();
            $table->string('groom_info_age_proof',100)->nullable();
            $table->string('groom_info_id_proof_file',100)->nullable();
            $table->string('groom_info_residential_proof_file',100)->nullable();
            $table->string('groom_info_age_proof_file',100)->nullable();
            $table->string('groom_info_upload_signature',100)->nullable();
            $table->string('groom_info_previous_status',100)->nullable();
            $table->string('groom_info_previous_status_proof',100)->nullable();
            $table->string('groom_info_upload_previous_status_proof',100)->nullable();



            $table->string('bride_info_fname_in_english',100)->nullable();
            $table->string('bride_info_mname_in_english',100)->nullable();
            $table->string('bride_info_lname_in_english',100)->nullable();
            $table->string('bride_info_fname_in_marathi',100)->nullable();
            $table->string('bride_info_mname_in_marathi',100)->nullable();
            $table->string('bride_info_lname_in_marathi',100)->nullable();
            $table->text('bride_info_address_in_english')->nullable();
            $table->text('bride_info_address_in_marathi')->nullable();
            $table->string('bride_info_pincode',100)->nullable();
            $table->string('bride_info_pincode_in_marathi',100)->nullable();
            $table->string('bride_info_mobile_no',100)->nullable();
            $table->string('bride_info_email',100)->nullable();
            $table->string('bride_info_aadhar_card_no',100)->nullable();
            $table->date('bride_info_dob')->nullable();
            $table->string('bride_info_age',100)->nullable();
            $table->string('bride_info_gender',100)->nullable();
            $table->string('bride_info_religion_by_birth',100)->nullable();
            $table->string('bride_info_religion_by_adoption',100)->nullable();
            $table->string('bride_info_photo',100)->nullable();
            $table->string('bride_info_id_proof',100)->nullable();
            $table->string('bride_info_residential_proof',100)->nullable();
            $table->string('bride_info_age_proof',100)->nullable();
            $table->string('bride_info_id_proof_file',100)->nullable();
            $table->string('bride_info_residential_proof_file',100)->nullable();
            $table->string('bride_info_age_proof_file',100)->nullable();
            $table->string('bride_info_upload_signature',100)->nullable();
            $table->string('bride_info_previous_status',100)->nullable();
            $table->string('bride_info_previous_status_proof',100)->nullable();
            $table->string('bride_info_upload_previous_status_proof',100)->nullable();


            $table->string('priest_info_fname_in_english',100,100)->nullable();
            $table->string('priest_info_mname_in_english',100)->nullable();
            $table->string('priest_info_lname_in_english',100)->nullable();
            $table->string('priest_info_fname_in_marathi',100)->nullable();
            $table->string('priest_info_mname_in_marathi',100)->nullable();
            $table->string('priest_info_lname_in_marathi',100)->nullable();
            $table->text('priest_info_address_in_english',100)->nullable();
            $table->text('priest_info_address_in_marathi')->nullable();
            $table->string('priest_info_mobile_no',100)->nullable();
            $table->string('priest_info_age',100)->nullable();
            $table->string('priest_info_religion',100)->nullable();
            $table->string('priest_info_upload_signature',100)->nullable();



            // Columns for first witness information
            $table->string('first_witness_info_fname_in_english',100)->nullable();
            $table->string('first_witness_info_fname_in_marathi',100)->nullable();
            $table->string('first_witness_info_mobile_no',100)->nullable();
            $table->string('first_witness_info_dob',100)->nullable();
            $table->string('first_witness_info_age',100)->nullable();
            $table->string('first_witness_info_gender',100)->nullable();
            $table->string('first_witness_info_relation',100)->nullable();
            $table->text('first_witness_info_address_in_english')->nullable();
            $table->text('first_witness_info_address_in_marathi')->nullable();
            $table->string('first_witness_info_id_proof',100)->nullable();
            $table->string('first_witness_info_witness_photo',100)->nullable();
            $table->string('first_witness_info_upload_signature',100)->nullable();
            $table->string('first_witness_info_upload_document',100)->nullable();

            // Columns for second witness information
            $table->string('second_witness_info_fname_in_english',100)->nullable();
            $table->string('second_witness_info_fname_in_marathi',100)->nullable();
            $table->string('second_witness_info_mobile_no',100)->nullable();
            $table->string('second_witness_info_dob',100)->nullable();
            $table->string('second_witness_info_age',100)->nullable();
            $table->string('second_witness_info_gender',100)->nullable();
            $table->string('second_witness_info_relation',100)->nullable();
            $table->text('second_witness_info_address_in_english')->nullable();
            $table->text('second_witness_info_address_in_marathi')->nullable();
            $table->string('second_witness_info_id_proof',100)->nullable();
            $table->string('second_witness_info_witness_photo',100)->nullable();
            $table->string('second_witness_info_upload_signature',100)->nullable();
            $table->string('second_witness_info_upload_document',100)->nullable();

            // Columns for third witness information
            $table->string('third_witness_info_fname_in_english',100)->nullable();
            $table->string('third_witness_info_fname_in_marathi',100)->nullable();
            $table->string('third_witness_info_mobile_no',100)->nullable();
            $table->string('third_witness_info_dob',100)->nullable();
            $table->string('third_witness_info_age',100)->nullable();
            $table->string('third_witness_info_gender',100)->nullable();
            $table->string('third_witness_info_relation',100)->nullable();
            $table->text('third_witness_info_address_in_english')->nullable();
            $table->text('third_witness_info_address_in_marathi')->nullable();
            $table->string('third_witness_info_id_proof',100)->nullable();
            $table->string('third_witness_info_witness_photo',100)->nullable();
            $table->string('third_witness_info_upload_signature',100)->nullable();
            $table->string('third_witness_info_upload_document',100)->nullable();
            $table->string('status',100)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('marriage_new_reg_details');
    }
};
