<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_change_in_uses', function (Blueprint $table) {
            //
            $table->string('Water_Connection_Number')->nullable();
            $table->string('Connection_Type')->nullable();
            $table->string('House_Number')->nullable();
            $table->string('Full_Address_Of_The_Property')->nullable();
            $table->string('Water_Connection_Usage')->nullable();
            $table->string('OutstandingAmt')->nullable();
            $table->string('Ward')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_change_in_uses', function (Blueprint $table) {
            //
            $table->dropColumn('Water_Connection_Number');
            $table->dropColumn('Connection_Type');
            $table->dropColumn('House_Number');
            $table->dropColumn('Full_Address_Of_The_Property');
            $table->dropColumn('Water_Connection_Usage');
            $table->dropColumn('OutstandingAmt');
            $table->dropColumn('Ward');
        });
    }
};
