<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_change_connection_sizes', function (Blueprint $table) {
            //
            $table->string('applicant_name')->nullable();
            $table->string('connection_no')->nullable();
            $table->string('property_tax')->nullable();
            $table->string('sub_usage')->nullable();
            $table->string('requirement_water_connection')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_change_connection_sizes', function (Blueprint $table) {
            //
            $table->dropColumn('applicant_name');
            $table->dropColumn('connection_no');
            $table->dropColumn('property_tax');
            $table->dropColumn('sub_usage');
            $table->dropColumn('requirement_water_connection');
        });
    }
};
