<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('approval_request_hierarchies', function (Blueprint $table) {
            $table->foreignId('first_department_id')->nullable()->constrained('departments');
            $table->foreignId('second_department_id')->nullable()->constrained('departments');
            $table->foreignId('third_department_id')->nullable()->constrained('departments');
            $table->foreignId('fourth_department_id')->nullable()->constrained('departments');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('approval_request_hierarchies', function (Blueprint $table) {
            $table->dropColumn('first_department_id')->nullable()->constrained('departments');
            $table->dropColumn('second_department_id')->nullable()->constrained('departments');
            $table->dropColumn('third_department_id')->nullable()->constrained('departments');
            $table->dropColumn('fourth_department_id')->nullable()->constrained('departments');
        });
    }
};
