<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('approval_request_hierarchies', function (Blueprint $table) {
            $table->foreignId('five_department_id')->nullable()->constrained('departments');
            $table->foreignId('six_department_id')->nullable()->constrained('departments');
            $table->foreignId('seven_department_id')->nullable()->constrained('departments');
            $table->foreignId('eight_department_id')->nullable()->constrained('departments');
            $table->unsignedBigInteger('five_approver_designation_id')->nullable();
            $table->unsignedBigInteger('six_approver_designation_id')->nullable();
            $table->unsignedBigInteger('seven_approver_designation_id')->nullable();
            $table->unsignedBigInteger('eight_approver_designation_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('approval_request_hierarchies', function (Blueprint $table) {
            $table->dropColumn('five_department_id')->nullable()->constrained('departments');
            $table->dropColumn('six_department_id')->nullable()->constrained('departments');
            $table->dropColumn('seven_department_id')->nullable()->constrained('departments');
            $table->dropColumn('eight_department_id')->nullable()->constrained('departments');
            $table->unsignedBigInteger('five_approver_designation_id')->nullable();
            $table->unsignedBigInteger('six_approver_designation_id')->nullable();
            $table->unsignedBigInteger('seven_approver_designation_id')->nullable();
            $table->unsignedBigInteger('eight_approver_designation_id')->nullable();
        });
    }
};
