<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prabhag_wards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('prabhag_id');
            $table->string('ward_name');
            $table->boolean('status')->default(1);
            $table->timestamps();

            $table->foreign('prabhag_id')->references('id')->on('prabhag')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prabhag_wards');
    }
};
