<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trade_noc_for_mandaps', function (Blueprint $table) {
             $table->date('registration_date')->nullable();
            $table->string('last_year_permission')->nullable();
            $table->string('ganesh_murti_type')->nullable(); 
            $table->decimal('murti_height', 5, 2)->nullable(); 
            $table->string('mandap_documents')->nullable(); 
            $table->string('local_polic_documents')->nullable(); 
            $table->string('applicant_mobile');
            $table->string('applicant_email');
            $table->text('applicant_address');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trade_noc_for_mandaps', function (Blueprint $table) {
            $table->dropColumn([
                'registration_date',
                'last_year_permission',
                'ganesh_murti_type',
                'murti_height',
                'mandap_documents',
                'local_polic_documents',
                'applicant_mobile',
                'applicant_email',
                'applicant_address',
            ]);
        });
    }
};
