<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_unavailability_supplies', function (Blueprint $table) {
            //
            $table->string('water_connection_number')->nullable();
            $table->string('connection_no')->nullable();
            $table->string('Connection_Type')->nullable();
            $table->string('House_Number')->nullable();
            $table->string('Property_Owner_Name')->nullable();
            $table->string('Full_Address_Of_The_Property')->nullable();
            $table->string('Water_Connection_Size')->nullable();
            $table->string('Water_Connection_Usage')->nullable();
            $table->string('OutstandingAmt')->nullable();
            $table->string('Ward')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_unavailability_supplies', function (Blueprint $table) {
            //
            $table->dropColumn('Water_Connection_Number');
            $table->dropColumn('Connection_Type');
            $table->dropColumn('House_Number');
            $table->dropColumn('Property_Owner_Name');
            $table->dropColumn('Full_Address_Of_The_Property');
            $table->dropColumn('Water_Connection_Size');
            $table->dropColumn('Water_Connection_Usage');
            $table->dropColumn('OutstandingAmt');
            $table->dropColumn('Ward');
            $table->dropColumn('connection_no');
        });
    }
};
