<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_change_ownerships', function (Blueprint $table) {
            //
            $table->string('existing_water_bill')->nullable();
            $table->string('tax_bill_or_transfer_order')->nullable();
            $table->string('stamp_paper_or_noobjection_cert')->nullable();
            $table->string('aadhar_doc')->nullable();
            $table->string('electricity_bill_or_pan_card')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_change_ownerships', function (Blueprint $table) {
            //
            $table->dropColumn('existing_water_bill');
            $table->dropColumn('tax_bill_or_transfer_order');
            $table->dropColumn('stamp_paper_or_noobjection_cert');
            $table->dropColumn('aadhar_doc');
            $table->dropColumn('electricity_bill_or_pan_card');

        });
    }
};
