<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('construction_drainage_connections', function (Blueprint $table) {
            //
            $table->string('connection_count')->nullable()->after('property_usage');
            $table->string('oc_cc_doc')->nullable()->after('connection_size_feet');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('construction_drainage_connections', function (Blueprint $table) {
            //
            $table->dropColumn('connection_count');
            $table->dropColumn('oc_cc_doc');
        });
    }
};
