<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('construction_road_cuttings', function (Blueprint $table) {
            // Drop the column only if it exists
            if (Schema::hasColumn('construction_road_cuttings', 'upload_related_docs')) {
                $table->dropColumn('upload_related_docs');
            }
        });
    }

    public function down(): void
    {
        Schema::table('construction_road_cuttings', function (Blueprint $table) {
            // Restore the column on rollback
            $table->string('upload_related_docs')->nullable();
        });
    }
};
