<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('granting_telecoms', function (Blueprint $table) {
            // Add gps_doc column after tax_doc
            if (!Schema::hasColumn('granting_telecoms', 'gps_doc')) {
                $table->string('gps_doc')->nullable()->after('tax_doc');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('granting_telecoms', function (Blueprint $table) {
            $table->dropColumn('gps_doc');
        });
    }
};
