<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First rename the column
        Schema::table('failure_water_supply', function (Blueprint $table) {
            $table->renameColumn('bill_doc', 'site_photo');
        });

        // Then add the new columns
        Schema::table('failure_water_supply', function (Blueprint $table) {
            $table->string('cc_oc')->nullable()->after('site_photo');
            $table->string('blue_print')->nullable()->after('cc_oc');
            $table->string('other_doc')->nullable()->after('blue_print');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('failure_water_supply', function (Blueprint $table) {
            //
            $table->renameColumn('site_photo', 'bill_doc');
            $table->dropColumn('cc_oc');
            $table->dropColumn('blue_print');
            $table->dropColumn('other_doc');
        });
    }
};
