<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('demand_safai', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->nullable()->after('id');
            // अगर आप relation भी चाहते हैं तो नीचे foreign key भी दे सकते हैं:
            // $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('demand_safai', function (Blueprint $table) {
            // अगर foreign key जोड़ा है तो पहले dropForeign करना
            // $table->dropForeign(['user_id']);
            $table->dropColumn('user_id');
        });
    }
};
