<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('sbi_payments', function (Blueprint $table) {
            // Change float to decimal with higher precision (15 digits total, 2 after decimal)
            $table->decimal('amount', 15, 2)->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('sbi_payments', function (Blueprint $table) {
            // Revert back to original float type
            $table->float('amount')->nullable()->change();
        });
    }
};

