<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('waternewconnections', function (Blueprint $table) {
            $table->decimal('running_meter', 10, 2)->nullable()->after('jramount')
                  ->comment('Total running meter length for road repair');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('waternewconnections', function (Blueprint $table) {
            $table->dropColumn('running_meter');
        });
    }
};