<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('water_pressure_complaints', function (Blueprint $table) {
            // Add new columns
            $table->decimal('jramountone', 10, 2)->nullable()->after('connection_no');
            $table->decimal('running_meterone', 10, 2)->nullable()->after('jramountone');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('water_pressure_complaints', function (Blueprint $table) {
            // Drop columns if rolled back
            $table->dropColumn(['jramountone', 'running_meterone']);
        });
    }
};