<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('demand_safai', function (Blueprint $table) {
            // Add service_id column
            $table->unsignedBigInteger('service_id')->nullable()->after('id');

            // Add foreign key constraint
            $table->foreign('service_id')
                  ->references('id')
                  ->on('service_names')
                  ->onDelete('cascade'); // adjust if you want different behavior
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('demand_safai', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['service_id']);

            // Drop column
            $table->dropColumn('service_id');
        });
    }
};
