<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fees_masters', function (Blueprint $table) {
            // Drop foreign key if it exists
            $smForeignKey = 'fees_masters_service_name_id_foreign';
            if (Schema::hasColumn('fees_masters', 'service_name_id')) {
                $sm = Schema::getConnection()->getDoctrineSchemaManager();
                $doctrineTable = $sm->listTableDetails('fees_masters');
                if ($doctrineTable->hasForeignKey($smForeignKey)) {
                    $table->dropForeign($smForeignKey);
                }
            }

            // Ensure column exists and is unsigned big integer (no FK)
            $table->unsignedBigInteger('service_name_id')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fees_masters', function (Blueprint $table) {
            // Optionally, re-add foreign key (if needed)
            $table->foreign('service_name_id')
                ->references('id')
                ->on('service_names')
                ->onDelete('cascade');
        });
    }
};
