<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('property_division_into_sub_divisions', function (Blueprint $table) {
            $table->date('payment_date')->nullable();
            $table->tinyInteger('is_payment_paid')->nullable();
            $table->tinyInteger('is_payment_paid_aapale_sarkar')->nullable();
            $table->date('aapale_sarkar_payment_date')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('property_division_into_sub_divisions', function (Blueprint $table) {
            $table->dropColumn([
                'payment_date',
                'is_payment_paid',
                'is_payment_paid_aapale_sarkar',
                'aapale_sarkar_payment_date',
            ]);
        });
    }
};
