<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('statuses', function (Blueprint $table) {
            $table->tinyInteger('receipt_status')->default(0)->after('user_id'); // 0 = pending, 1 = verified, 2 = rejected
            $table->text('receipt_remark')->nullable()->after('receipt_status');
            $table->foreignId('receipt_verifier_id')
                ->nullable()
                ->after('receipt_remark')
                ->constrained('users');
            $table->foreignId('receipt_verified_by')
                ->nullable()
                ->after('receipt_verifier_id')
                ->constrained('users');

            $table->decimal('fees_amount', 10, 2)->default(0)->after('receipt_verified_by');

            $table->timestamp('receipt_uploaded_at')->nullable()->after('fees_amount'); // new column


        });
    }

    public function down(): void
    {
        Schema::table('statuses', function (Blueprint $table) {
            $table->dropForeign(['receipt_verifier_id']);
            $table->dropForeign(['receipt_verified_by']);
            $table->dropColumn(['receipt_status', 'receipt_remark', 'receipt_verifier_id', 'receipt_verified_by', 'fees_amount','receipt_uploaded_at']);
        });
    }

};
